/*
 * DCA compatible decoder - huffman tables
 * Copyright (C) 2004 Gildas Bazin
 * Copyright (C) 2007 Konstantin Shishkov
 *
 * This file is part of FFmpeg.
 *
 * FFmpeg is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * FFmpeg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with FFmpeg; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

#include <stddef.h>

#include "libavutil/macros.h"

#include "dcadata.h"
#include "dcahuff.h"

static const uint8_t bitalloc_12_vlc_bits[DCA_BITALLOC_12_COUNT] = {
    9, 7, 7, 9, 9
};

#define SCALES_VLC_BITS 9
static const uint8_t tnl_grp_sizes[] = { 37, 34, 31, 28, 23 };

const uint8_t ff_dca_bitalloc_sizes[DCA_CODE_BOOKS] = {
    3, 5, 7, 9, 13, 17, 25, 33, 65, 129
};

const int8_t ff_dca_bitalloc_offsets[DCA_CODE_BOOKS] = {
    -1, -2, -3, -4, -6, -8, -12, -16, -32, -64
};

static const uint8_t bitalloc_maxbits[DCA_CODE_BOOKS][7] = {
    { 2 },
    { 4, 3, 3 },
    { 5, 5, 4 },
    { 6, 5, 6 },
    { 7, 6, 5 },
    { 9, 8, 7, 9, 8, 8, 8 },
    { 9, 9, 8, 9, 8, 9, 9 },
    { 9, 9, 9, 9, 9, 9, 9 },
    { 9, 9, 9, 9, 9, 9, 9 },
    { 9, 9, 9, 9, 9, 9, 9 }
};

const uint8_t ff_dca_vlc_src_tables[][2] = {
    /* bitalloc_3 - 3 entries */
    {   1,   1 }, {   2,   2 }, {   0,   2 },
    /* bitalloc_5_a - 5 entries */
    {   2,   1 }, {   3,   2 }, {   1,   3 }, {   4,   4 }, {   0,   4 },
    /* bitalloc_5_b - 5 entries */
    {   3,   2 }, {   1,   2 }, {   2,   2 }, {   4,   3 }, {   0,   3 },
    /* bitalloc_5_c - 5 entries */
    {   2,   1 }, {   3,   3 }, {   1,   3 }, {   4,   3 }, {   0,   3 },
    /* bitalloc_7_a - 7 entries */
    {   3,   1 }, {   5,   3 }, {   2,   3 }, {   4,   3 }, {   1,   4 },
    {   0,   5 }, {   6,   5 },
    /* bitalloc_7_b - 7 entries */
    {   2,   2 }, {   4,   2 }, {   5,   3 }, {   0,   5 }, {   6,   5 },
    {   1,   4 }, {   3,   2 },
    /* bitalloc_7_c - 7 entries */
    {   0,   4 }, {   6,   4 }, {   1,   4 }, {   5,   4 }, {   2,   2 },
    {   4,   2 }, {   3,   2 },
    /* bitalloc_9_a - 9 entries */
    {   4,   1 }, {   7,   4 }, {   2,   4 }, {   3,   3 }, {   0,   6 },
    {   8,   6 }, {   1,   5 }, {   6,   4 }, {   5,   3 },
    /* bitalloc_9_b - 9 entries */
    {   5,   2 }, {   2,   3 }, {   6,   3 }, {   4,   2 }, {   0,   5 },
    {   8,   5 }, {   1,   5 }, {   7,   5 }, {   3,   3 },
    /* bitalloc_9_c - 9 entries */
    {   5,   2 }, {   2,   3 }, {   7,   4 }, {   0,   6 }, {   8,   6 },
    {   1,   5 }, {   4,   2 }, {   6,   3 }, {   3,   3 },
    /* bitalloc_13_a - 13 entries */
    {   6,   1 }, {   7,   3 }, {   9,   4 }, {  10,   5 }, {   1,   6 },
    {  11,   6 }, {   4,   4 }, {   8,   4 }, {   0,   7 }, {  12,   7 },
    {   2,   6 }, {   3,   5 }, {   5,   4 },
    /* bitalloc_13_b - 13 entries */
    {   6,   2 }, {   8,   3 }, {  10,   4 }, {   3,   4 }, {   1,   5 },
    {  11,   5 }, {   9,   4 }, {   5,   3 }, {   7,   3 }, {   0,   6 },
    {  12,   6 }, {   2,   5 }, {   4,   4 },
    /* bitalloc_13_c - 13 entries */
    {   4,   3 }, {   0,   5 }, {  12,   5 }, {   2,   4 }, {   8,   3 },
    {   5,   3 }, {   7,   3 }, {   6,   3 }, {  10,   4 }, {   1,   5 },
    {  11,   5 }, {   3,   4 }, {   9,   4 },
    /* bitalloc_17_a - 17 entries */
    {  12,   4 }, {  13,   6 }, {  14,   8 }, {  15,  10 }, {   0,  12 },
    {  16,  12 }, {   1,  11 }, {   2,   9 }, {   3,   7 }, {   4,   5 },
    {   6,   3 }, {   8,   2 }, {  10,   3 }, {   5,   4 }, {  11,   4 },
    {   7,   3 }, {   9,   3 },
    /* bitalloc_17_b - 17 entries */
    {   8,   2 }, {  10,   3 }, {  15,   6 }, {   2,   6 }, {   3,   5 },
    {  13,   5 }, {  14,   6 }, {   0,   8 }, {  16,   8 }, {   1,   7 },
    {   5,   4 }, {  11,   4 }, {   7,   3 }, {   9,   3 }, {   4,   5 },
    {  12,   5 }, {   6,   4 },
    /* bitalloc_17_c - 17 entries */
    {  10,   3 }, {  15,   5 }, {   2,   5 }, {   4,   4 }, {  12,   4 },
    {  14,   5 }, {   0,   7 }, {  16,   7 }, {   1,   6 }, {   7,   3 },
    {   9,   3 }, {   5,   4 }, {  11,   4 }, {   8,   3 }, {   3,   5 },
    {  13,   5 }, {   6,   4 },
    /* bitalloc_17_d - 17 entries */
    {   8,   1 }, {   0,   9 }, {  16,   9 }, {   1,   9 }, {  15,   9 },
    {   2,   8 }, {  14,   8 }, {   3,   7 }, {  13,   7 }, {   4,   6 },
    {  12,   6 }, {   5,   5 }, {  11,   5 }, {   6,   4 }, {  10,   4 },
    {   7,   3 }, {   9,   3 },
    /* bitalloc_17_e - 17 entries */
    {   8,   1 }, {   7,   3 }, {   9,   3 }, {  10,   4 }, {   3,   6 },
    {  13,   6 }, {   5,   5 }, {  11,   5 }, {   0,   8 }, {  16,   8 },
    {   2,   7 }, {   4,   6 }, {  12,   6 }, {  14,   7 }, {   1,   8 },
    {  15,   8 }, {   6,   5 },
    /* bitalloc_17_f - 17 entries */
    {  15,   6 }, {   0,   8 }, {  16,   8 }, {   1,   7 }, {   3,   5 },
    {   4,   4 }, {   6,   3 }, {  10,   3 }, {  12,   4 }, {  13,   5 },
    {   2,   6 }, {  14,   6 }, {   7,   3 }, {   9,   3 }, {   8,   3 },
    {   5,   4 }, {  11,   4 },
    /* bitalloc_17_g - 17 entries */
    {   6,   3 }, {  10,   3 }, {   5,   4 }, {  11,   4 }, {   0,   8 },
    {  16,   8 }, {   2,   7 }, {   3,   6 }, {   4,   5 }, {  12,   5 },
    {  13,   6 }, {  14,   7 }, {   1,   8 }, {  15,   8 }, {   8,   2 },
    {   7,   3 }, {   9,   3 },
    /* bitalloc_25_a - 25 entries */
    {  10,   3 }, {  14,   3 }, {   8,   4 }, {  16,   4 }, {  11,   3 },
    {  13,   3 }, {  21,   8 }, {  22,  10 }, {  23,  12 }, {   0,  14 },
    {  24,  14 }, {   1,  13 }, {   2,  11 }, {   3,   9 }, {   4,   8 },
    {  20,   8 }, {   5,   7 }, {  19,   7 }, {   7,   5 }, {  17,   5 },
    {   6,   6 }, {  18,   6 }, {  12,   3 }, {   9,   4 }, {  15,   4 },
    /* bitalloc_25_b - 25 entries */
    {   3,   6 }, {  21,   6 }, {  23,   7 }, {   2,   7 }, {  22,   7 },
    {   0,   9 }, {  24,   9 }, {   1,   8 }, {   8,   4 }, {  11,   3 },
    {  13,   3 }, {  16,   4 }, {   6,   5 }, {  18,   5 }, {   9,   4 },
    {  15,   4 }, {  12,   3 }, {   4,   6 }, {  20,   6 }, {   7,   5 },
    {  17,   5 }, {   5,   6 }, {  19,   6 }, {  10,   4 }, {  14,   4 },
    /* bitalloc_25_c - 25 entries */
    {   7,   4 }, {  17,   4 }, {  12,   3 }, {  20,   5 }, {  22,   6 },
    {   0,   8 }, {  24,   8 }, {   1,   7 }, {   8,   4 }, {  16,   4 },
    {   5,   5 }, {  19,   5 }, {   9,   4 }, {  15,   4 }, {   3,   6 },
    {  21,   6 }, {   6,   5 }, {  10,   4 }, {  14,   4 }, {  18,   5 },
    {  23,   7 }, {   2,   7 }, {   4,   6 }, {  11,   4 }, {  13,   4 },
    /* bitalloc_25_d - 25 entries */
    {  10,   3 }, {  14,   3 }, {   9,   4 }, {  15,   4 }, {   8,   5 },
    {  16,   5 }, {   7,   6 }, {  17,   6 }, {   0,  12 }, {  24,  12 },
    {   1,  12 }, {  23,  12 }, {   2,  11 }, {  22,  11 }, {   3,  10 },
    {  21,  10 }, {   5,   8 }, {   6,   7 }, {  18,   7 }, {  19,   8 },
    {   4,   9 }, {  20,   9 }, {  12,   2 }, {  11,   3 }, {  13,   3 },
    /* bitalloc_25_e - 25 entries */
    {   9,   4 }, {  15,   4 }, {   7,   5 }, {  17,   5 }, {   2,   7 },
    {  22,   7 }, {   5,   6 }, {  19,   6 }, {   0,   8 }, {  24,   8 },
    {   3,   7 }, {  11,   3 }, {  13,   3 }, {   8,   5 }, {  16,   5 },
    {  21,   7 }, {   1,   8 }, {  23,   8 }, {   6,   6 }, {  18,   6 },
    {   4,   7 }, {  20,   7 }, {  10,   4 }, {  14,   4 }, {  12,   2 },
    /* bitalloc_25_f - 25 entries */
    {  13,   3 }, {  12,   3 }, {   7,   4 }, {  17,   4 }, {   5,   5 },
    {  19,   5 }, {   8,   4 }, {  16,   4 }, {   4,   6 }, {  20,   6 },
    {   6,   5 }, {   9,   4 }, {  15,   4 }, {  18,   5 }, {  23,   8 },
    {   0,  10 }, {  24,  10 }, {   1,   9 }, {   3,   7 }, {  21,   7 },
    {   2,   8 }, {  22,   8 }, {  10,   4 }, {  14,   4 }, {  11,   4 },
    /* bitalloc_25_g - 25 entries */
    {  14,   3 }, {  17,   5 }, {   4,   7 }, {  20,   7 }, {   6,   6 },
    {   9,   4 }, {  12,   2 }, {  15,   4 }, {  18,   6 }, {   3,   8 },
    {  21,   8 }, {   5,   7 }, {   8,   5 }, {  11,   3 }, {  13,   3 },
    {  16,   5 }, {  19,   7 }, {   0,  10 }, {  24,  10 }, {   2,   9 },
    {  22,   9 }, {   1,  10 }, {  23,  10 }, {   7,   6 }, {  10,   4 },
    /* bitalloc_33_a - 33 entries */
    {  15,   3 }, {  17,   3 }, {  16,   3 }, {  21,   4 }, {   8,   6 },
    {  24,   6 }, {  10,   5 }, {  12,   4 }, {  20,   4 }, {  22,   5 },
    {   7,   7 }, {  25,   7 }, {   0,  13 }, {  32,  13 }, {   1,  13 },
    {  31,  13 }, {   2,  12 }, {  30,  12 }, {   3,  11 }, {  29,  11 },
    {   4,  10 }, {  28,  10 }, {   6,   8 }, {  26,   8 }, {   5,   9 },
    {  27,   9 }, {  13,   4 }, {  19,   4 }, {  14,   4 }, {  18,   4 },
    {   9,   6 }, {  23,   6 }, {  11,   5 },
    /* bitalloc_33_b - 33 entries */
    {   8,   5 }, {  24,   5 }, {  12,   4 }, {  16,   3 }, {  20,   4 },
    {   3,   7 }, {  29,   7 }, {   6,   6 }, {   9,   5 }, {  23,   5 },
    {  26,   6 }, {  31,   8 }, {   2,   8 }, {   4,   7 }, {  13,   4 },
    {  19,   4 }, {  10,   5 }, {  22,   5 }, {  14,   4 }, {  18,   4 },
    {  28,   7 }, {  30,   8 }, {   0,  10 }, {  32,  10 }, {   1,   9 },
    {   7,   6 }, {  25,   6 }, {   5,   7 }, {  27,   7 }, {  11,   5 },
    {  21,   5 }, {  15,   4 }, {  17,   4 },
    /* bitalloc_33_c - 33 entries */
    {  25,   5 }, {  31,   7 }, {   2,   7 }, {   4,   6 }, {  12,   4 },
    {  20,   4 }, {  13,   4 }, {  19,   4 }, {   8,   5 }, {  24,   5 },
    {  28,   6 }, {  30,   7 }, {   0,   9 }, {  32,   9 }, {   1,   8 },
    {   5,   6 }, {  27,   6 }, {  14,   4 }, {  18,   4 }, {   9,   5 },
    {  23,   5 }, {  15,   4 }, {  17,   4 }, {  10,   5 }, {  22,   5 },
    {  16,   4 }, {   3,   7 }, {  29,   7 }, {   6,   6 }, {  11,   5 },
    {  21,   5 }, {  26,   6 }, {   7,   6 },
    /* bitalloc_33_d - 33 entries */
    {  18,   3 }, {  21,   5 }, {   8,   7 }, {  24,   7 }, {  10,   6 },
    {  13,   4 }, {  16,   2 }, {  19,   4 }, {  22,   6 }, {   7,   8 },
    {  25,   8 }, {   9,   7 }, {  12,   5 }, {  15,   3 }, {  17,   3 },
    {  20,   5 }, {  23,   7 }, {   6,   9 }, {  26,   9 }, {   5,  10 },
    {  27,  10 }, {   4,  11 }, {  28,  11 }, {   3,  12 }, {  29,  12 },
    {   0,  14 }, {  32,  14 }, {   1,  14 }, {  31,  14 }, {   2,  13 },
    {  30,  13 }, {  11,   6 }, {  14,   4 },
    /* bitalloc_33_e - 33 entries */
    {  19,   4 }, {  11,   5 }, {  21,   5 }, {  15,   3 }, {  17,   3 },
    {   5,   7 }, {  27,   7 }, {   2,   8 }, {  30,   8 }, {   6,   7 },
    {   9,   6 }, {  23,   6 }, {  14,   4 }, {  16,   2 }, {  18,   4 },
    {  12,   5 }, {  20,   5 }, {  26,   7 }, {   3,   8 }, {  29,   8 },
    {   0,   9 }, {  32,   9 }, {   4,   8 }, {   7,   7 }, {  10,   6 },
    {  22,   6 }, {  25,   7 }, {  28,   8 }, {   1,   9 }, {  31,   9 },
    {   8,   7 }, {  24,   7 }, {  13,   5 },
    /* bitalloc_33_f - 33 entries */
    {  11,   4 }, {  21,   4 }, {   5,   6 }, {  27,   6 }, {   8,   5 },
    {  12,   4 }, {  20,   4 }, {  24,   5 }, {   4,   7 }, {  28,   7 },
    {   6,   6 }, {  13,   4 }, {  19,   4 }, {  14,   4 }, {  18,   4 },
    {   9,   5 }, {  23,   5 }, {  15,   4 }, {  17,   4 }, {  16,   4 },
    {  26,   6 }, {  31,   9 }, {   0,  11 }, {  32,  11 }, {   1,  10 },
    {   3,   8 }, {  29,   8 }, {   2,   9 }, {  30,   9 }, {  10,   5 },
    {  22,   5 }, {   7,   6 }, {  25,   6 },
    /* bitalloc_33_g - 33 entries */
    {  12,   4 }, {  20,   4 }, {  29,   8 }, {   1,   9 }, {  31,   9 },
    {   6,   7 }, {   8,   6 }, {  10,   5 }, {  22,   5 }, {  24,   6 },
    {  26,   7 }, {   4,   8 }, {  28,   8 }, {  15,   3 }, {  17,   3 },
    {  13,   4 }, {  19,   4 }, {   2,   9 }, {  30,   9 }, {   0,  10 },
    {  32,  10 }, {   3,   9 }, {   7,   7 }, {   9,   6 }, {  11,   5 },
    {  21,   5 }, {  23,   6 }, {  25,   7 }, {   5,   8 }, {  27,   8 },
    {  16,   3 }, {  14,   4 }, {  18,   4 },
    /* bitalloc_65_a - 65 entries */
    {  35,   4 }, {  30,   4 }, {  34,   4 }, {  42,   5 }, {  23,   5 },
    {  31,   4 }, {  33,   4 }, {  32,   4 }, {  41,   5 }, {  19,   6 },
    {  45,   6 }, {  16,   7 }, {  48,   7 }, {  20,   6 }, {  24,   5 },
    {  40,   5 }, {  44,   6 }, {  14,   8 }, {  50,   8 }, {  57,  11 },
    {   4,  13 }, {  60,  13 }, {   6,  12 }, {  58,  12 }, {   3,  14 },
    {  61,  14 }, {   2,  15 }, {  62,  15 }, {   0,  16 }, {  64,  16 },
    {   1,  16 }, {  63,  16 }, {   8,  11 }, {  12,   9 }, {  52,   9 },
    {  10,  10 }, {  54,  10 }, {  25,   5 }, {  39,   5 }, {  17,   7 },
    {  47,   7 }, {  21,   6 }, {  26,   5 }, {  38,   5 }, {  43,   6 },
    {  15,   8 }, {  49,   8 }, {  18,   7 }, {  27,   5 }, {  37,   5 },
    {  28,   5 }, {  36,   5 }, {  46,   7 }, {  56,  11 }, {   5,  13 },
    {  59,  13 }, {   7,  12 }, {   9,  11 }, {  55,  11 }, {  13,   9 },
    {  51,   9 }, {  11,  10 }, {  53,  10 }, {  22,   6 }, {  29,   5 },
    /* bitalloc_65_b - 65 entries */
    {  48,   6 }, {   3,   9 }, {  61,   9 }, {   6,   8 }, {  11,   7 },
    {  53,   7 }, {  58,   8 }, {   7,   8 }, {  17,   6 }, {  31,   4 },
    {  33,   4 }, {  24,   5 }, {  40,   5 }, {  32,   4 }, {  47,   6 },
    {  18,   6 }, {  25,   5 }, {  39,   5 }, {  46,   6 }, {  57,   8 },
    {  63,  10 }, {   2,  10 }, {   4,   9 }, {  12,   7 }, {  52,   7 },
    {  13,   7 }, {  19,   6 }, {  26,   5 }, {  38,   5 }, {  45,   6 },
    {  51,   7 }, {   8,   8 }, {  56,   8 }, {  27,   5 }, {  37,   5 },
    {  20,   6 }, {  44,   6 }, {  60,   9 }, {  62,  10 }, {   0,  12 },
    {  64,  12 }, {   1,  11 }, {   5,   9 }, {  59,   9 }, {  14,   7 },
    {  50,   7 }, {   9,   8 }, {  55,   8 }, {  28,   5 }, {  36,   5 },
    {  21,   6 }, {  43,   6 }, {  29,   5 }, {  35,   5 }, {  15,   7 },
    {  49,   7 }, {  22,   6 }, {  42,   6 }, {  10,   8 }, {  54,   8 },
    {  16,   7 }, {  30,   5 }, {  34,   5 }, {  23,   6 }, {  41,   6 },
    /* bitalloc_65_c - 65 entries */
    {  23,   5 }, {  41,   5 }, {  50,   6 }, {   8,   7 }, {  56,   7 },
    {  24,   5 }, {  40,   5 }, {  15,   6 }, {  49,   6 }, {  25,   5 },
    {  39,   5 }, {  16,   6 }, {  48,   6 }, {  26,   5 }, {  38,   5 },
    {  60,   8 }, {   5,   8 }, {   9,   7 }, {  55,   7 }, {  10,   7 },
    {  27,   5 }, {  37,   5 }, {  17,   6 }, {  47,   6 }, {  28,   5 },
    {  36,   5 }, {  54,   7 }, {  59,   8 }, {  62,   9 }, {   0,  11 },
    {  64,  11 }, {   1,  10 }, {  18,   6 }, {  29,   5 }, {  35,   5 },
    {  46,   6 }, {  11,   7 }, {  53,   7 }, {  19,   6 }, {  45,   6 },
    {  30,   5 }, {  34,   5 }, {  31,   5 }, {  33,   5 }, {   6,   8 },
    {  58,   8 }, {  12,   7 }, {  20,   6 }, {  44,   6 }, {  52,   7 },
    {   3,   9 }, {  61,   9 }, {   7,   8 }, {  32,   5 }, {  21,   6 },
    {  43,   6 }, {  13,   7 }, {  51,   7 }, {  22,   6 }, {  42,   6 },
    {  57,   8 }, {  63,  10 }, {   2,  10 }, {   4,   9 }, {  14,   7 },
    /* bitalloc_65_d - 65 entries */
    {  31,   3 }, {  33,   3 }, {  48,   8 }, {  11,  10 }, {  53,  10 },
    {  14,   9 }, {  50,   9 }, {   9,  11 }, {  55,  11 }, {  12,  10 },
    {  17,   8 }, {  20,   7 }, {  44,   7 }, {  23,   6 }, {  41,   6 },
    {  26,   5 }, {  38,   5 }, {  29,   4 }, {  35,   4 }, {  32,   3 },
    {  47,   8 }, {  52,  10 }, {  60,  13 }, {   3,  14 }, {  61,  14 },
    {   7,  12 }, {  57,  12 }, {   5,  13 }, {  59,  13 }, {  15,   9 },
    {  18,   8 }, {  46,   8 }, {  21,   7 }, {  43,   7 }, {  24,   6 },
    {  40,   6 }, {  27,   5 }, {  37,   5 }, {  30,   4 }, {  34,   4 },
    {  49,   9 }, {  10,  11 }, {  54,  11 }, {  13,  10 }, {  51,  10 },
    {   8,  12 }, {  56,  12 }, {   0,  15 }, {  64,  15 }, {   1,  15 },
    {  63,  15 }, {   2,  15 }, {  62,  15 }, {   4,  14 }, {   6,  13 },
    {  58,  13 }, {  16,   9 }, {  19,   8 }, {  45,   8 }, {  22,   7 },
    {  42,   7 }, {  25,   6 }, {  39,   6 }, {  28,   5 }, {  36,   5 },
    /* bitalloc_65_e - 65 entries */
    {  33,   3 }, {  21,   6 }, {  43,   6 }, {  26,   5 }, {  38,   5 },
    {  16,   7 }, {  48,   7 }, {  22,   6 }, {  42,   6 }, {  10,   8 },
    {  54,   8 }, {   4,   9 }, {  60,   9 }, {  11,   8 }, {  27,   5 },
    {  37,   5 }, {  17,   7 }, {  47,   7 }, {  23,   6 }, {  30,   4 },
    {  34,   4 }, {  32,   3 }, {  41,   6 }, {  53,   8 }, {   5,   9 },
    {  59,   9 }, {  18,   7 }, {  46,   7 }, {  12,   8 }, {  52,   8 },
    {  24,   6 }, {  28,   5 }, {  36,   5 }, {  40,   6 }, {   6,   9 },
    {  58,   9 }, {  13,   8 }, {  19,   7 }, {  45,   7 }, {  51,   8 },
    {   0,  10 }, {  64,  10 }, {   7,   9 }, {  57,   9 }, {   1,  10 },
    {  63,  10 }, {  14,   8 }, {  50,   8 }, {   8,   9 }, {  56,   9 },
    {  20,   7 }, {  44,   7 }, {  25,   6 }, {  39,   6 }, {  15,   8 },
    {  49,   8 }, {   2,  10 }, {  62,  10 }, {   9,   9 }, {  55,   9 },
    {   3,  10 }, {  61,  10 }, {  29,   5 }, {  35,   5 }, {  31,   4 },
    /* bitalloc_65_f - 65 entries */
    {  28,   4 }, {  36,   4 }, {  26,   5 }, {  38,   5 }, {  24,   6 },
    {  40,   6 }, {  22,   7 }, {  42,   7 }, {  20,   8 }, {  44,   8 },
    {  18,   9 }, {  46,   9 }, {  48,  10 }, {  50,  11 }, {  12,  12 },
    {  52,  12 }, {   0,  14 }, {  64,  14 }, {   1,  14 }, {  63,  14 },
    {  10,  13 }, {  54,  13 }, {   2,  14 }, {  62,  14 }, {   3,  14 },
    {  61,  14 }, {   4,  14 }, {  60,  14 }, {   5,  14 }, {  59,  14 },
    {   6,  14 }, {  58,  14 }, {   7,  14 }, {  57,  14 }, {   8,  14 },
    {  56,  14 }, {  11,  13 }, {  15,  11 }, {  31,   3 }, {  33,   3 },
    {  29,   4 }, {  35,   4 }, {  27,   5 }, {  37,   5 }, {  25,   6 },
    {  39,   6 }, {  23,   7 }, {  41,   7 }, {  21,   8 }, {  43,   8 },
    {  19,   9 }, {  45,   9 }, {  17,  10 }, {  47,  10 }, {  49,  11 },
    {  13,  12 }, {  51,  12 }, {  53,  13 }, {   9,  14 }, {  55,  14 },
    {  14,  12 }, {  16,  11 }, {  32,   3 }, {  30,   4 }, {  34,   4 },
    /* bitalloc_65_g - 65 entries */
    {  36,   4 }, {  40,   5 }, {  44,   6 }, {  48,   7 }, {  12,   8 },
    {  52,   8 }, {   8,   9 }, {  56,   9 }, {   4,  10 }, {  60,  10 },
    {   0,  11 }, {  64,  11 }, {   5,  10 }, {  17,   7 }, {  21,   6 },
    {  25,   5 }, {  29,   4 }, {  35,   4 }, {  39,   5 }, {  43,   6 },
    {  47,   7 }, {  13,   8 }, {  51,   8 }, {  30,   4 }, {   9,   9 },
    {  55,   9 }, {  59,  10 }, {   1,  11 }, {  63,  11 }, {  10,   9 },
    {  18,   7 }, {  22,   6 }, {  26,   5 }, {  34,   4 }, {  38,   5 },
    {  42,   6 }, {  46,   7 }, {  14,   8 }, {  50,   8 }, {  31,   4 },
    {  33,   4 }, {  54,   9 }, {   6,  10 }, {  58,  10 }, {   2,  11 },
    {  62,  11 }, {   7,  10 }, {  11,   9 }, {  19,   7 }, {  23,   6 },
    {  27,   5 }, {  37,   5 }, {  41,   6 }, {  45,   7 }, {  15,   8 },
    {  49,   8 }, {  32,   4 }, {  53,   9 }, {  57,  10 }, {   3,  11 },
    {  61,  11 }, {  16,   8 }, {  20,   7 }, {  24,   6 }, {  28,   5 },
    /* bitalloc_129_a - 129 entries */
    {  66,   4 }, {  31,   8 }, {  97,   8 }, {  19,   9 }, { 109,   9 },
    {   6,  10 }, { 122,  10 }, {   7,  10 }, { 121,  10 }, {  52,   6 },
    {  76,   6 }, {  43,   7 }, {  85,   7 }, {  59,   5 }, {  69,   5 },
    {  32,   8 }, {  96,   8 }, {  20,   9 }, { 108,   9 }, {  33,   8 },
    {  53,   6 }, {  75,   6 }, {  95,   8 }, {   8,  10 }, { 120,  10 },
    {  21,   9 }, {  44,   7 }, {  84,   7 }, { 107,   9 }, {   9,  10 },
    { 119,  10 }, {  34,   8 }, {  94,   8 }, {  22,   9 }, { 106,   9 },
    {  45,   7 }, {  54,   6 }, {  74,   6 }, {  83,   7 }, {  10,  10 },
    { 118,  10 }, {  23,   9 }, {  35,   8 }, {  93,   8 }, { 105,   9 },
    {  11,  10 }, { 117,  10 }, {  46,   7 }, {  60,   5 }, {  68,   5 },
    {  82,   7 }, {  24,   9 }, { 104,   9 }, {  36,   8 }, {  55,   6 },
    {  73,   6 }, {  92,   8 }, {  12,  10 }, { 116,  10 }, {  25,   9 },
    {  47,   7 }, {  81,   7 }, {  37,   8 }, {  91,   8 }, { 103,   9 },
    {  13,  10 }, { 115,  10 }, {  26,   9 }, { 102,   9 }, {  48,   7 },
    {  64,   4 }, {  63,   4 }, {  65,   4 }, {  56,   6 }, {  72,   6 },
    {  61,   5 }, {  67,   5 }, {  80,   7 }, {  38,   8 }, {  90,   8 },
    {   0,  11 }, { 128,  11 }, {  14,  10 }, { 114,  10 }, {   1,  11 },
    { 127,  11 }, {  27,   9 }, { 101,   9 }, {  49,   7 }, {  79,   7 },
    {  39,   8 }, {  89,   8 }, {  57,   6 }, {  71,   6 }, {  15,  10 },
    { 113,  10 }, {  28,   9 }, { 100,   9 }, {   2,  11 }, { 126,  11 },
    {  16,  10 }, {  40,   8 }, {  88,   8 }, {  50,   7 }, {  78,   7 },
    { 112,  10 }, {   3,  11 }, { 125,  11 }, {  29,   9 }, {  99,   9 },
    {  17,  10 }, { 111,  10 }, {  41,   8 }, {  87,   8 }, {  58,   6 },
    {   4,  11 }, { 124,  11 }, {  18,  10 }, {  30,   9 }, {  98,   9 },
    { 110,  10 }, {   5,  11 }, { 123,  11 }, {  51,   7 }, {  70,   6 },
    {  77,   7 }, {  42,   8 }, {  86,   8 }, {  62,   5 },
    /* bitalloc_129_b - 129 entries */
    {  67,   5 }, {  21,   8 }, { 107,   8 }, {  33,   7 }, {  95,   7 },
    {  13,   9 }, { 115,   9 }, {  22,   8 }, {  47,   6 }, {  81,   6 },
    {  62,   5 }, {  66,   5 }, {  34,   7 }, {  94,   7 }, {  48,   6 },
    {  63,   5 }, {  65,   5 }, {  80,   6 }, { 106,   8 }, { 121,  10 },
    { 127,  12 }, {   2,  12 }, {   4,  11 }, {  14,   9 }, {  23,   8 },
    { 105,   8 }, {  35,   7 }, {  93,   7 }, {  49,   6 }, {  64,   5 },
    {  79,   6 }, { 114,   9 }, {   8,  10 }, { 120,  10 }, {  24,   8 },
    {  36,   7 }, {  50,   6 }, {  78,   6 }, {  92,   7 }, { 104,   8 },
    {  15,   9 }, { 113,   9 }, {  51,   6 }, {  77,   6 }, {  37,   7 },
    {  91,   7 }, {  25,   8 }, { 103,   8 }, {  38,   7 }, {  52,   6 },
    {  76,   6 }, {  90,   7 }, {  16,   9 }, { 112,   9 }, {  26,   8 },
    {  53,   6 }, {  75,   6 }, { 102,   8 }, { 124,  11 }, {   5,  11 },
    {   9,  10 }, { 119,  10 }, {  10,  10 }, {  39,   7 }, {  89,   7 },
    {  27,   8 }, { 101,   8 }, {  54,   6 }, {  74,   6 }, {  40,   7 },
    {  88,   7 }, {  17,   9 }, { 111,   9 }, {  28,   8 }, { 100,   8 },
    { 118,  10 }, { 123,  11 }, { 126,  12 }, {   0,  14 }, { 128,  14 },
    {   1,  13 }, {  18,   9 }, {  55,   6 }, {  73,   6 }, {  41,   7 },
    {  87,   7 }, {  56,   6 }, {  72,   6 }, {  29,   8 }, {  99,   8 },
    {  42,   7 }, {  86,   7 }, { 110,   9 }, {  11,  10 }, { 117,  10 },
    {  19,   9 }, { 109,   9 }, {  57,   6 }, {  71,   6 }, {  43,   7 },
    {  85,   7 }, {  58,   6 }, {  70,   6 }, {  30,   8 }, {  98,   8 },
    {  44,   7 }, {  84,   7 }, {  31,   8 }, {  97,   8 }, {  59,   6 },
    {  69,   6 }, {   6,  11 }, { 122,  11 }, {  12,  10 }, {  20,   9 },
    { 108,   9 }, { 116,  10 }, {   3,  12 }, { 125,  12 }, {   7,  11 },
    {  45,   7 }, {  60,   6 }, {  68,   6 }, {  83,   7 }, {  32,   8 },
    {  96,   8 }, {  46,   7 }, {  82,   7 }, {  61,   6 },
    /* bitalloc_129_c - 129 entries */
    { 101,   7 }, { 113,   8 }, { 120,   9 }, { 127,  11 }, {   2,  11 },
    {   4,  10 }, {  28,   7 }, { 100,   7 }, {  46,   6 }, {  82,   6 },
    {  16,   8 }, { 112,   8 }, {  29,   7 }, {  47,   6 }, {  81,   6 },
    {  48,   6 }, {  80,   6 }, {  99,   7 }, {  30,   7 }, {  98,   7 },
    {  17,   8 }, { 111,   8 }, {  49,   6 }, {  79,   6 }, {  50,   6 },
    {  78,   6 }, {  31,   7 }, {  97,   7 }, {   9,   9 }, { 119,   9 },
    {  18,   8 }, { 110,   8 }, { 124,  10 }, {   5,  10 }, {  10,   9 },
    {  51,   6 }, {  77,   6 }, {  32,   7 }, {  96,   7 }, {  52,   6 },
    {  76,   6 }, {  33,   7 }, {  95,   7 }, {  53,   6 }, {  75,   6 },
    {  19,   8 }, { 109,   8 }, {  34,   7 }, {  54,   6 }, {  74,   6 },
    {  94,   7 }, { 118,   9 }, { 123,  10 }, { 126,  11 }, {   0,  13 },
    { 128,  13 }, {   1,  12 }, {  20,   8 }, {  55,   6 }, {  73,   6 },
    { 108,   8 }, {  11,   9 }, { 117,   9 }, {  35,   7 }, {  93,   7 },
    {  36,   7 }, {  56,   6 }, {  72,   6 }, {  92,   7 }, {  21,   8 },
    { 107,   8 }, {  57,   6 }, {  71,   6 }, {  37,   7 }, {  91,   7 },
    {  58,   6 }, {  70,   6 }, {  22,   8 }, { 106,   8 }, {  38,   7 },
    {  59,   6 }, {  69,   6 }, {  90,   7 }, {  12,   9 }, { 116,   9 },
    {  23,   8 }, {  60,   6 }, {  68,   6 }, {  39,   7 }, {  89,   7 },
    {  61,   6 }, {  67,   6 }, { 105,   8 }, {   6,  10 }, { 122,  10 },
    {  13,   9 }, {  40,   7 }, {  62,   6 }, {  66,   6 }, {  88,   7 },
    {  24,   8 }, { 104,   8 }, {  63,   6 }, {  65,   6 }, {  41,   7 },
    {  87,   7 }, { 115,   9 }, {   3,  11 }, { 125,  11 }, {   7,  10 },
    {  25,   8 }, {  42,   7 }, {  64,   6 }, {  86,   7 }, { 103,   8 },
    {  14,   9 }, { 114,   9 }, {  43,   7 }, {  85,   7 }, {  26,   8 },
    { 102,   8 }, {  44,   7 }, {  84,   7 }, { 121,  10 }, {   8,  10 },
    {  15,   9 }, {  27,   8 }, {  45,   7 }, {  83,   7 },
    /* bitalloc_129_d - 129 entries */
    {  72,   5 }, {  83,   7 }, {  34,   9 }, {  94,   9 }, {  40,   8 },
    {  51,   6 }, {  62,   4 }, {  66,   4 }, {  77,   6 }, {  88,   8 },
    {  18,  12 }, { 110,  12 }, {   9,  14 }, { 119,  14 }, {  14,  13 },
    {  19,  12 }, {  29,  10 }, {  99,  10 }, {  24,  11 }, { 104,  11 },
    {  46,   7 }, {  57,   5 }, {  71,   5 }, {  82,   7 }, {  35,   9 },
    {  93,   9 }, {  41,   8 }, {  52,   6 }, {  63,   4 }, {  65,   4 },
    {  76,   6 }, {  87,   8 }, {  30,  10 }, {  98,  10 }, { 109,  12 },
    { 114,  13 }, {   6,  15 }, { 122,  15 }, {  10,  14 }, {  25,  11 },
    { 103,  11 }, {  15,  13 }, { 113,  13 }, {  20,  12 }, {  47,   7 },
    {  58,   5 }, {  70,   5 }, {  81,   7 }, {  36,   9 }, {  92,   9 },
    {  42,   8 }, {  53,   6 }, {  64,   4 }, {  75,   6 }, {  86,   8 },
    {  31,  10 }, {  97,  10 }, { 108,  12 }, { 118,  14 }, {   7,  15 },
    { 121,  15 }, {   0,  16 }, { 128,  16 }, {   1,  16 }, { 127,  16 },
    {   2,  16 }, { 126,  16 }, {   3,  16 }, { 125,  16 }, {  26,  11 },
    { 102,  11 }, {  11,  14 }, { 117,  14 }, {  16,  13 }, {  21,  12 },
    {  48,   7 }, {  59,   5 }, {  69,   5 }, {  80,   7 }, {  37,   9 },
    {  91,   9 }, {  43,   8 }, {  54,   6 }, {  74,   6 }, {  85,   8 },
    {  32,  10 }, {  96,  10 }, { 107,  12 }, { 112,  13 }, {   4,  16 },
    { 124,  16 }, {   8,  15 }, {  12,  14 }, {  27,  11 }, { 101,  11 },
    {  22,  12 }, { 106,  12 }, {  49,   7 }, {  60,   5 }, {  68,   5 },
    {  79,   7 }, {  38,   9 }, {  90,   9 }, {  44,   8 }, {  55,   6 },
    {  73,   6 }, {  84,   8 }, {  33,  10 }, {  95,  10 }, { 116,  14 },
    { 120,  15 }, {   5,  16 }, { 123,  16 }, {  17,  13 }, { 111,  13 },
    {  13,  14 }, { 115,  14 }, {  28,  11 }, { 100,  11 }, {  23,  12 },
    { 105,  12 }, {  50,   7 }, {  61,   5 }, {  67,   5 }, {  78,   7 },
    {  39,   9 }, {  89,   9 }, {  45,   8 }, {  56,   6 },
    /* bitalloc_129_e - 129 entries */
    {  70,   5 }, {  59,   5 }, {  69,   5 }, {  60,   5 }, {  68,   5 },
    {  37,   7 }, {  91,   7 }, {  45,   6 }, {  61,   5 }, {  67,   5 },
    {  62,   5 }, {  66,   5 }, {  63,   5 }, {  65,   5 }, {  64,   5 },
    {  83,   6 }, {  97,   8 }, { 102,   9 }, {  18,  11 }, { 110,  11 },
    {  22,  10 }, {  38,   7 }, {  46,   6 }, {  82,   6 }, {  90,   7 },
    {  32,   8 }, {  96,   8 }, {  47,   6 }, {  81,   6 }, { 106,  10 },
    {  15,  12 }, { 113,  12 }, {  19,  11 }, {  27,   9 }, { 101,   9 },
    {  23,  10 }, { 105,  10 }, {  39,   7 }, {  89,   7 }, {  33,   8 },
    {  95,   8 }, {  48,   6 }, {  80,   6 }, {  49,   6 }, {  79,   6 },
    {  40,   7 }, {  88,   7 }, {  28,   9 }, { 100,   9 }, { 109,  11 },
    {   6,  15 }, { 122,  15 }, {   9,  14 }, {  12,  13 }, { 116,  13 },
    { 119,  14 }, {   0,  16 }, {   4,  16 }, {   3,  16 }, {   2,  16 },
    {  24,  10 }, { 104,  10 }, {  16,  12 }, { 112,  12 }, {  20,  11 },
    {  34,   8 }, {  94,   8 }, {  50,   6 }, {  78,   6 }, {  41,   7 },
    {  87,   7 }, {  51,   6 }, {  77,   6 }, {  52,   6 }, {  76,   6 },
    {  29,   9 }, {  99,   9 }, {  35,   8 }, {  42,   7 }, {  86,   7 },
    {  93,   8 }, { 108,  11 }, {   1,  16 }, { 128,  16 }, { 126,  16 },
    { 127,  16 }, { 124,  16 }, { 125,  16 }, {   7,  15 }, {  13,  13 },
    { 115,  13 }, {  10,  14 }, { 118,  14 }, {  25,  10 }, { 103,  10 },
    {  17,  12 }, { 111,  12 }, {  21,  11 }, {  53,   6 }, {  75,   6 },
    {  54,   6 }, {  74,   6 }, {  43,   7 }, {  85,   7 }, {  55,   6 },
    {  73,   6 }, {  30,   9 }, {  98,   9 }, {  36,   8 }, {  92,   8 },
    { 107,  11 }, { 121,  15 }, {   5,  16 }, { 123,  16 }, {   8,  15 },
    { 120,  15 }, {  14,  13 }, { 114,  13 }, {  11,  14 }, { 117,  14 },
    {  26,  10 }, {  31,   9 }, {  56,   6 }, {  72,   6 }, {  57,   6 },
    {  71,   6 }, {  44,   7 }, {  84,   7 }, {  58,   6 },
    /* bitalloc_129_f - 129 entries */
    {  42,   6 }, {  86,   6 }, {  43,   6 }, {  85,   6 }, { 107,   8 },
    { 114,   9 }, {   9,  10 }, { 119,  10 }, {  30,   7 }, {  98,   7 },
    {  31,   7 }, {  44,   6 }, {  84,   6 }, {  45,   6 }, {  83,   6 },
    {  97,   7 }, {  22,   8 }, { 106,   8 }, {  46,   6 }, {  82,   6 },
    {  32,   7 }, {  96,   7 }, {  47,   6 }, {  81,   6 }, {  15,   9 },
    { 113,   9 }, {  23,   8 }, { 105,   8 }, {  10,  10 }, { 118,  10 },
    {  16,   9 }, {  48,   6 }, {  80,   6 }, {  33,   7 }, {  95,   7 },
    {  49,   6 }, {  79,   6 }, {  50,   6 }, {  78,   6 }, { 112,   9 },
    {   3,  12 }, { 125,  12 }, {   6,  11 }, { 122,  11 }, {   7,  11 },
    {  24,   8 }, {  34,   7 }, {  51,   6 }, {  77,   6 }, {  94,   7 },
    { 104,   8 }, {  11,  10 }, { 117,  10 }, {  17,   9 }, {  52,   6 },
    {  76,   6 }, {  53,   6 }, {  75,   6 }, {  35,   7 }, {  93,   7 },
    {  54,   6 }, {  74,   6 }, {  55,   6 }, {  73,   6 }, {  25,   8 },
    { 103,   8 }, {  36,   7 }, {  56,   6 }, {  72,   6 }, {  57,   6 },
    {  71,   6 }, {  92,   7 }, { 111,   9 }, { 121,  11 }, { 127,  13 },
    {   2,  13 }, {   4,  12 }, {  12,  10 }, {  18,   9 }, { 110,   9 },
    {  58,   6 }, {  70,   6 }, {  59,   6 }, {  69,   6 }, {  60,   6 },
    {  68,   6 }, {  61,   6 }, {  67,   6 }, {  62,   6 }, {  66,   6 },
    {  26,   8 }, { 102,   8 }, {  37,   7 }, {  63,   6 }, {  65,   6 },
    {  64,   6 }, {  91,   7 }, {  38,   7 }, {  90,   7 }, {  27,   8 },
    { 101,   8 }, { 116,  10 }, { 124,  12 }, { 126,  13 }, {   0,  15 },
    { 128,  15 }, {   1,  14 }, {   8,  11 }, {  19,   9 }, { 109,   9 },
    {  13,  10 }, { 115,  10 }, {  39,   7 }, {  89,   7 }, {  28,   8 },
    { 100,   8 }, {  40,   7 }, {  88,   7 }, {  41,   7 }, {  87,   7 },
    {  20,   9 }, { 108,   9 }, {  29,   8 }, {  99,   8 }, { 120,  11 },
    {   5,  12 }, { 123,  12 }, {  14,  10 }, {  21,   9 },
    /* bitalloc_129_g - 129 entries */
    {  64,   4 }, {  88,   7 }, {   9,  11 }, { 119,  11 }, {  17,  10 },
    {  25,   9 }, {  33,   8 }, {  41,   7 }, {  87,   7 }, {  49,   6 },
    {  79,   6 }, {  57,   5 }, {  71,   5 }, {  95,   8 }, { 103,   9 },
    { 111,  10 }, {   2,  12 }, { 126,  12 }, {  10,  11 }, {  18,  10 },
    { 110,  10 }, {  26,   9 }, {  34,   8 }, {  42,   7 }, {  86,   7 },
    {  50,   6 }, {  78,   6 }, {  58,   5 }, {  70,   5 }, {  94,   8 },
    { 102,   9 }, { 118,  11 }, {   3,  12 }, { 125,  12 }, {  11,  11 },
    { 117,  11 }, {  19,  10 }, { 109,  10 }, {  27,   9 }, {  35,   8 },
    {  43,   7 }, {  85,   7 }, {  51,   6 }, {  77,   6 }, {  59,   5 },
    {  69,   5 }, {  93,   8 }, { 101,   9 }, {   4,  12 }, { 124,  12 },
    {  12,  11 }, {  20,  10 }, {  28,   9 }, { 100,   9 }, {  36,   8 },
    {  44,   7 }, {  84,   7 }, {  52,   6 }, {  76,   6 }, {  60,   5 },
    {  68,   5 }, {  92,   8 }, { 108,  10 }, { 116,  11 }, {   5,  12 },
    { 123,  12 }, {  13,  11 }, { 115,  11 }, {  21,  10 }, {  29,   9 },
    {  99,   9 }, {  37,   8 }, {  45,   7 }, {  83,   7 }, {  53,   6 },
    {  75,   6 }, {  61,   5 }, {  67,   5 }, {  91,   8 }, { 107,  10 },
    {   6,  12 }, { 122,  12 }, {  14,  11 }, {  22,  10 }, { 106,  10 },
    {  30,   9 }, {  98,   9 }, {  38,   8 }, {  46,   7 }, {  82,   7 },
    {  54,   6 }, {  74,   6 }, {  62,   5 }, {  66,   5 }, {  90,   8 },
    { 114,  11 }, {   7,  12 }, { 121,  12 }, {  15,  11 }, { 113,  11 },
    {  23,  10 }, { 105,  10 }, {  31,   9 }, {  97,   9 }, {  39,   8 },
    {  47,   7 }, {  81,   7 }, {  55,   6 }, {  73,   6 }, {  63,   5 },
    {  65,   5 }, {  89,   8 }, {   0,  13 }, { 128,  13 }, {   8,  12 },
    {  16,  11 }, {  24,  10 }, {  32,   9 }, {  96,   9 }, { 104,  10 },
    { 112,  11 }, { 120,  12 }, {   1,  13 }, { 127,  13 }, {  40,   8 },
    {  48,   7 }, {  80,   7 }, {  56,   6 }, {  72,   6 },
    /* bit_alloc_12[0] - 12 entries */
    {   0,   1 }, {   1,   2 }, {   2,   3 }, {   3,   4 }, {   4,   5 },
    {   5,   6 }, {  11,   9 }, {  10,   9 }, {   9,   9 }, {   8,   9 },
    {   7,   8 }, {   6,   8 },
    /* bit_alloc_12[1] - 12 entries */
    {   1,   2 }, {   2,   3 }, {   4,   5 }, {  11,   7 }, {  10,   7 },
    {   9,   7 }, {   8,   7 }, {   7,   7 }, {   6,   7 }, {   5,   6 },
    {   3,   5 }, {   0,   1 },
    /* bit_alloc_12[2] - 12 entries */
    {   0,   2 }, {   4,   3 }, {   7,   4 }, {  11,   7 }, {  10,   7 },
    {   9,   6 }, {   8,   5 }, {   3,   3 }, {   2,   3 }, {   6,   4 },
    {   5,   4 }, {   1,   3 },
    /* bit_alloc_12[3] - 12 entries */
    {   2,   2 }, {   3,   3 }, {   4,   4 }, {   5,   5 }, {   6,   6 },
    {   7,   7 }, {   8,   8 }, {   9,   9 }, {  11,  10 }, {  10,  10 },
    {   1,   2 }, {   0,   2 },
    /* bit_alloc_12[4] - 12 entries */
    {   1,   2 }, {   2,   3 }, {   3,   4 }, {   4,   5 }, {   9,   8 },
    {   8,   8 }, {   6,   7 }, {   7,   8 }, {  11,   9 }, {  10,   9 },
    {   5,   7 }, {   0,   1 },
    /* scale_factor[0] - 129 entries */
    {  66,   3 }, {  69,   5 }, {  55,   8 }, {  73,   8 }, {  40,  13 },
    {  88,  13 }, {  41,  13 }, {  87,  13 }, {  42,  13 }, {  86,  13 },
    {  43,  13 }, {  85,  13 }, {  44,  13 }, {  84,  13 }, {  45,  13 },
    {  83,  13 }, {  46,  13 }, {  82,  13 }, {  47,  13 }, {  81,  13 },
    {  51,  11 }, {  77,  11 }, {  48,  13 }, {  80,  13 }, {  50,  12 },
    {  78,  12 }, {  49,  13 }, {  79,  13 }, {  54,   9 }, {  74,   9 },
    {  58,   6 }, {  61,   4 }, {  64,   2 }, {  67,   4 }, {  70,   6 },
    {  57,   7 }, {  71,   7 }, {  60,   5 }, {  63,   3 }, {  65,   3 },
    {  68,   5 }, {  56,   8 }, {  72,   8 }, {  53,  10 }, {  75,  10 },
    {  52,  11 }, {  76,  11 }, {   0,  14 }, { 128,  14 }, {   1,  14 },
    { 127,  14 }, {   2,  14 }, { 126,  14 }, {   3,  14 }, { 125,  14 },
    {   4,  14 }, { 124,  14 }, {   5,  14 }, { 123,  14 }, {   6,  14 },
    { 122,  14 }, {   7,  14 }, { 121,  14 }, {   8,  14 }, { 120,  14 },
    {   9,  14 }, { 119,  14 }, {  10,  14 }, { 118,  14 }, {  11,  14 },
    { 117,  14 }, {  12,  14 }, { 116,  14 }, {  13,  14 }, { 115,  14 },
    {  14,  14 }, { 114,  14 }, {  15,  14 }, { 113,  14 }, {  16,  14 },
    { 112,  14 }, {  17,  14 }, { 111,  14 }, {  18,  14 }, { 110,  14 },
    {  19,  14 }, { 109,  14 }, {  20,  14 }, { 108,  14 }, {  21,  14 },
    { 107,  14 }, {  22,  14 }, { 106,  14 }, {  23,  14 }, { 105,  14 },
    {  24,  14 }, { 104,  14 }, {  25,  14 }, { 103,  14 }, {  26,  14 },
    { 102,  14 }, {  27,  14 }, { 101,  14 }, {  28,  14 }, { 100,  14 },
    {  29,  14 }, {  99,  14 }, {  30,  14 }, {  98,  14 }, {  31,  14 },
    {  97,  14 }, {  32,  14 }, {  96,  14 }, {  33,  14 }, {  95,  14 },
    {  34,  14 }, {  94,  14 }, {  35,  14 }, {  93,  14 }, {  36,  14 },
    {  92,  14 }, {  37,  14 }, {  91,  14 }, {  38,  14 }, {  90,  14 },
    {  39,  14 }, {  89,  14 }, {  59,   6 }, {  62,   4 },
    /* scale_factor[1] - 129 entries */
    {  69,   4 }, {  56,   6 }, {  72,   6 }, {  55,   7 }, {  73,   7 },
    {  54,   8 }, {  74,   8 }, {  75,   9 }, {  48,  14 }, {  80,  14 },
    {  49,  14 }, {  79,  14 }, {  50,  13 }, {  78,  13 }, {  51,  12 },
    {  77,  12 }, {   0,  15 }, { 128,  15 }, {   1,  15 }, { 127,  15 },
    {   2,  15 }, { 126,  15 }, {   3,  15 }, { 125,  15 }, {   4,  15 },
    { 124,  15 }, {   5,  15 }, { 123,  15 }, {   6,  15 }, { 122,  15 },
    {   7,  15 }, { 121,  15 }, {   8,  15 }, { 120,  15 }, {   9,  15 },
    { 119,  15 }, {  10,  15 }, { 118,  15 }, {  11,  15 }, { 117,  15 },
    {  12,  15 }, { 116,  15 }, {  13,  15 }, { 115,  15 }, {  14,  15 },
    { 114,  15 }, {  15,  15 }, { 113,  15 }, {  16,  15 }, { 112,  15 },
    {  17,  15 }, { 111,  15 }, {  18,  15 }, { 110,  15 }, {  19,  15 },
    { 109,  15 }, {  20,  15 }, { 108,  15 }, {  21,  15 }, { 107,  15 },
    {  22,  15 }, { 106,  15 }, {  23,  15 }, { 105,  15 }, {  24,  15 },
    { 104,  15 }, {  25,  15 }, { 103,  15 }, {  26,  15 }, { 102,  15 },
    {  27,  15 }, { 101,  15 }, {  28,  15 }, { 100,  15 }, {  29,  15 },
    {  99,  15 }, {  30,  15 }, {  98,  15 }, {  31,  15 }, {  97,  15 },
    {  32,  15 }, {  96,  15 }, {  33,  15 }, {  95,  15 }, {  34,  15 },
    {  94,  15 }, {  35,  15 }, {  93,  15 }, {  36,  15 }, {  92,  15 },
    {  37,  15 }, {  91,  15 }, {  38,  15 }, {  90,  15 }, {  39,  15 },
    {  89,  15 }, {  40,  15 }, {  88,  15 }, {  41,  15 }, {  87,  15 },
    {  42,  15 }, {  86,  15 }, {  43,  15 }, {  85,  15 }, {  44,  15 },
    {  84,  15 }, {  45,  15 }, {  83,  15 }, {  46,  15 }, {  82,  15 },
    {  47,  15 }, {  81,  15 }, {  52,  11 }, {  76,  11 }, {  53,  10 },
    {  63,   3 }, {  65,   3 }, {  64,   3 }, {  58,   5 }, {  70,   5 },
    {  60,   4 }, {  68,   4 }, {  61,   4 }, {  67,   4 }, {  57,   6 },
    {  71,   6 }, {  59,   5 }, {  62,   4 }, {  66,   4 },
    /* scale_factor[2] - 129 entries */
    {  63,   3 }, {  65,   3 }, {  46,   9 }, {  82,   9 }, {  49,   8 },
    {  79,   8 }, {  85,  10 }, {  38,  12 }, {  90,  12 }, {  41,  11 },
    {  87,  11 }, {  93,  13 }, {  33,  14 }, {  95,  14 }, {  36,  13 },
    {  92,  13 }, {  44,  10 }, {  52,   7 }, {  76,   7 }, {  55,   6 },
    {  73,   6 }, {  58,   5 }, {  70,   5 }, {  61,   4 }, {  67,   4 },
    {  64,   3 }, {  47,   9 }, {  81,   9 }, {  50,   8 }, {  78,   8 },
    {  84,  10 }, {  39,  12 }, {  89,  12 }, {  42,  11 }, {  86,  11 },
    {   0,  15 }, { 128,  15 }, {   1,  15 }, { 127,  15 }, {   2,  15 },
    { 126,  15 }, {   3,  15 }, { 125,  15 }, {   4,  15 }, { 124,  15 },
    {   5,  15 }, { 123,  15 }, {   6,  15 }, { 122,  15 }, {   7,  15 },
    { 121,  15 }, {   8,  15 }, { 120,  15 }, {   9,  15 }, { 119,  15 },
    {  10,  15 }, { 118,  15 }, {  11,  15 }, { 117,  15 }, {  12,  15 },
    { 116,  15 }, {  13,  15 }, { 115,  15 }, {  14,  15 }, { 114,  15 },
    {  15,  15 }, { 113,  15 }, {  16,  15 }, { 112,  15 }, {  17,  15 },
    { 111,  15 }, {  18,  15 }, { 110,  15 }, {  19,  15 }, { 109,  15 },
    {  20,  15 }, { 108,  15 }, {  21,  15 }, { 107,  15 }, {  22,  15 },
    { 106,  15 }, {  23,  15 }, { 105,  15 }, {  53,   7 }, {  75,   7 },
    {  56,   6 }, {  72,   6 }, {  59,   5 }, {  69,   5 }, {  62,   4 },
    {  66,   4 }, {  45,  10 }, {  83,  10 }, {  48,   9 }, {  80,   9 },
    {  24,  15 }, { 104,  15 }, {  25,  15 }, { 103,  15 }, {  26,  15 },
    { 102,  15 }, {  27,  15 }, { 101,  15 }, {  28,  15 }, { 100,  15 },
    {  29,  15 }, {  99,  15 }, {  30,  15 }, {  98,  15 }, {  31,  15 },
    {  97,  15 }, {  34,  14 }, {  94,  14 }, {  37,  13 }, {  40,  12 },
    {  88,  12 }, {  91,  13 }, {  32,  15 }, {  96,  15 }, {  35,  14 },
    {  43,  11 }, {  51,   8 }, {  77,   8 }, {  54,   7 }, {  74,   7 },
    {  57,   6 }, {  71,   6 }, {  60,   5 }, {  68,   5 },
    /* scale_factor[3] - 129 entries */
    {  64,   2 }, {  53,   8 }, {  75,   8 }, {  55,   7 }, {  57,   6 },
    {  59,   5 }, {  69,   5 }, {  71,   6 }, {  73,   7 }, {  77,   9 },
    {  79,  10 }, {  83,  12 }, {  42,  14 }, {  86,  14 }, {  44,  13 },
    {  46,  12 }, {  82,  12 }, {  48,  11 }, {  80,  11 }, {  50,  10 },
    {  52,   9 }, {  61,   4 }, {  67,   4 }, {  63,   3 }, {  65,   3 },
    {  54,   8 }, {  74,   8 }, {  56,   7 }, {  58,   6 }, {  60,   5 },
    {  68,   5 }, {  70,   6 }, {  72,   7 }, {  76,   9 }, {  78,  10 },
    {  84,  13 }, {   0,  15 }, { 128,  15 }, {   1,  15 }, { 127,  15 },
    {   2,  15 }, { 126,  15 }, {   3,  15 }, { 125,  15 }, {   4,  15 },
    { 124,  15 }, {   5,  15 }, { 123,  15 }, {   6,  15 }, { 122,  15 },
    {   7,  15 }, { 121,  15 }, {   8,  15 }, { 120,  15 }, {   9,  15 },
    { 119,  15 }, {  10,  15 }, { 118,  15 }, {  11,  15 }, { 117,  15 },
    {  12,  15 }, { 116,  15 }, {  13,  15 }, { 115,  15 }, {  14,  15 },
    { 114,  15 }, {  15,  15 }, { 113,  15 }, {  16,  15 }, { 112,  15 },
    {  17,  15 }, { 111,  15 }, {  18,  15 }, { 110,  15 }, {  19,  15 },
    { 109,  15 }, {  20,  15 }, { 108,  15 }, {  21,  15 }, { 107,  15 },
    {  22,  15 }, { 106,  15 }, {  23,  15 }, { 105,  15 }, {  24,  15 },
    { 104,  15 }, {  25,  15 }, { 103,  15 }, {  26,  15 }, { 102,  15 },
    {  27,  15 }, { 101,  15 }, {  28,  15 }, { 100,  15 }, {  29,  15 },
    {  99,  15 }, {  30,  15 }, {  98,  15 }, {  31,  15 }, {  97,  15 },
    {  32,  15 }, {  96,  15 }, {  33,  15 }, {  95,  15 }, {  34,  15 },
    {  94,  15 }, {  35,  15 }, {  93,  15 }, {  36,  15 }, {  92,  15 },
    {  37,  15 }, {  91,  15 }, {  38,  15 }, {  90,  15 }, {  39,  15 },
    {  89,  15 }, {  40,  15 }, {  88,  15 }, {  41,  15 }, {  87,  15 },
    {  43,  14 }, {  85,  14 }, {  45,  13 }, {  47,  12 }, {  81,  12 },
    {  49,  11 }, {  51,  10 }, {  62,   4 }, {  66,   4 },
    /* scale_factor[4] - 129 entries */
    {  56,   5 }, {  72,   5 }, {  52,   6 }, {  76,   6 }, {  48,   7 },
    {  80,   7 }, {  44,   8 }, {  84,   8 }, {  40,   9 }, {  88,   9 },
    {  36,  10 }, {  92,  10 }, {  96,  11 }, {  28,  12 }, { 100,  12 },
    {  24,  13 }, { 104,  13 }, {  16,  15 }, { 112,  15 }, {  20,  14 },
    { 108,  14 }, {  21,  14 }, {  33,  11 }, {  61,   4 }, {  67,   4 },
    {  57,   5 }, {  71,   5 }, {  53,   6 }, {  75,   6 }, {  49,   7 },
    {  79,   7 }, {  45,   8 }, {  83,   8 }, {  41,   9 }, {  87,   9 },
    {  37,  10 }, {  91,  10 }, {  95,  11 }, {  29,  12 }, {  99,  12 },
    {  25,  13 }, { 103,  13 }, { 107,  14 }, {  17,  15 }, { 111,  15 },
    {  26,  13 }, {  34,  11 }, {  62,   4 }, {  66,   4 }, {  58,   5 },
    {  70,   5 }, {  54,   6 }, {  74,   6 }, {  50,   7 }, {  78,   7 },
    {  46,   8 }, {  82,   8 }, {  42,   9 }, {  86,   9 }, {  38,  10 },
    {  90,  10 }, {  94,  11 }, {  30,  12 }, {  98,  12 }, {  39,  10 },
    {  63,   4 }, {  65,   4 }, {  59,   5 }, {  69,   5 }, {  55,   6 },
    {  73,   6 }, {  51,   7 }, {  77,   7 }, {  47,   8 }, {  81,   8 },
    {  43,   9 }, {  85,   9 }, {  89,  10 }, { 102,  13 }, {  22,  14 },
    { 106,  14 }, {  18,  15 }, { 110,  15 }, {   0,  16 }, { 128,  16 },
    {   1,  16 }, { 127,  16 }, {  27,  13 }, {  35,  11 }, {  93,  11 },
    {  31,  12 }, {  97,  12 }, { 101,  13 }, {   2,  16 }, { 126,  16 },
    {   3,  16 }, { 125,  16 }, {   4,  16 }, { 124,  16 }, {   5,  16 },
    { 123,  16 }, {   6,  16 }, { 122,  16 }, {   7,  16 }, { 121,  16 },
    {   8,  16 }, { 120,  16 }, {   9,  16 }, { 119,  16 }, {  10,  16 },
    { 118,  16 }, {  11,  16 }, { 117,  16 }, {  12,  16 }, { 116,  16 },
    {  13,  16 }, { 115,  16 }, {  14,  16 }, { 114,  16 }, {  15,  16 },
    { 113,  16 }, {  23,  14 }, { 105,  14 }, {  19,  15 }, { 109,  15 },
    {  32,  12 }, {  64,   4 }, {  60,   5 }, {  68,   5 },
    /* transition_mode[0] - 4 entries */
    {   0,   1 }, {   1,   2 }, {   2,   3 }, {   3,   3 },
    /* transition_mode[1] - 4 entries */
    {   3,   1 }, {   0,   2 }, {   1,   3 }, {   2,   3 },
    /* transition_mode[2] - 4 entries */
    {   2,   1 }, {   3,   2 }, {   0,   3 }, {   1,   3 },
    /* transition_mode[3] - 4 entries */
    {   0,   2 }, {   1,   2 }, {   2,   2 }, {   3,   2 },
    /* tnl_group[0] - 37 entries */
    {   5,   3 }, {   4,   3 }, {  19,   8 }, {  33,  12 }, {  31,  12 },
    {  28,  11 }, {  34,  14 }, {  37,  14 }, {  35,  15 }, {   0,  15 },
    {  36,  14 }, {  32,  12 }, {  30,  11 }, {  24,   9 }, {  22,   8 },
    {  23,   9 }, {  29,  10 }, {  27,  10 }, {  17,   6 }, {  14,   5 },
    {   7,   4 }, {  12,   5 }, {   1,   6 }, {  26,   9 }, {   3,   9 },
    {  25,   8 }, {  20,   7 }, {   8,   4 }, {  10,   4 }, {  13,   4 },
    {  15,   6 }, {  16,   6 }, {  18,   6 }, {  21,   6 }, {  11,   4 },
    {   9,   3 }, {   6,   3 },
    /* tnl_group[1] - 34 entries */
    {   4,   4 }, {   7,   4 }, {  10,   4 }, {   3,  10 }, {  27,  10 },
    {  29,  10 }, {  28,  10 }, {  22,   8 }, {  21,   7 }, {  15,   6 },
    {  14,   5 }, {   8,   4 }, {  16,   6 }, {  19,   7 }, {  23,   8 },
    {  26,   9 }, {  30,  10 }, {  33,  13 }, {  34,  14 }, {   0,  14 },
    {  32,  12 }, {  31,  11 }, {  12,   5 }, {   5,   3 }, {   9,   3 },
    {   1,   4 }, {  20,   7 }, {  25,   8 }, {  24,   8 }, {  18,   6 },
    {  17,   5 }, {   6,   3 }, {  11,   4 }, {  13,   4 },
    /* tnl_group[2] - 31 entries */
    {  14,   7 }, {  17,   7 }, {  15,   7 }, {  23,   9 }, {  28,  10 },
    {  29,  11 }, {  30,  13 }, {   0,  13 }, {  31,  12 }, {  25,   8 },
    {  10,   5 }, {   8,   4 }, {   9,   4 }, {   4,   4 }, {  22,   8 },
    {   3,   8 }, {  21,   8 }, {  26,   9 }, {  27,   9 }, {  12,   6 },
    {  11,   5 }, {  16,   7 }, {  18,   7 }, {  20,   8 }, {  24,   8 },
    {  19,   7 }, {  13,   5 }, {   5,   3 }, {   1,   2 }, {   6,   3 },
    {   7,   3 },
    /* tnl_group[3] - 28 entries */
    {   8,   6 }, {   2,   6 }, {   7,   6 }, {  23,   7 }, {  12,   7 },
    {   5,   4 }, {  10,   6 }, {  20,   8 }, {  25,   9 }, {  26,  10 },
    {  27,  11 }, {   0,  11 }, {  22,   7 }, {   9,   5 }, {  13,   6 },
    {  17,   6 }, {   4,   5 }, {  14,   6 }, {  19,   7 }, {  24,   7 },
    {   3,   6 }, {  11,   6 }, {  21,   6 }, {  18,   6 }, {  16,   6 },
    {  15,   6 }, {   6,   3 }, {   1,   1 },
    /* tnl_group[4] - 23 entries */
    {   2,   2 }, {   7,   7 }, {  15,   8 }, {  21,   8 }, {   3,   6 },
    {   6,   6 }, {  13,   7 }, {  14,   8 }, {  18,   8 }, {   4,   4 },
    {   5,   5 }, {  11,   7 }, {  10,   7 }, {  20,   6 }, {  12,   8 },
    {  16,   9 }, {  22,  10 }, {   0,  10 }, {  17,   7 }, {  19,   6 },
    {   8,   6 }, {   9,   6 }, {   1,   1 },
    /* tnl_scf - 20 entries */
    {   3,   3 }, {  11,   6 }, {  16,   9 }, {  17,  10 }, {  18,  11 },
    {  19,  12 }, {   0,  12 }, {  15,   8 }, {  14,   7 }, {   9,   5 },
    {   7,   4 }, {   2,   3 }, {   4,   3 }, {   1,   3 }, {   5,   3 },
    {  12,   6 }, {  13,   6 }, {  10,   5 }, {   8,   4 }, {   6,   3 },
    /* damp - 7 entries */
    {   2,   2 }, {   3,   3 }, {   4,   4 }, {   5,   5 }, {   6,   6 },
    {   0,   6 }, {   1,   1 },
    /* dph - 9 entries */
    {   2,   2 }, {   1,   2 }, {   3,   4 }, {   7,   4 }, {   6,   5 },
    {   5,   6 }, {   0,   6 }, {   4,   4 }, {   8,   2 },
    /* fst_rsd_amp - 24 entries */
    {  12,   4 }, {  17,   4 }, {   1,   6 }, {   8,   6 }, {   9,   5 },
    {  20,   7 }, {   3,   7 }, {   5,   6 }, {   6,   6 }, {   2,   7 },
    {  22,   9 }, {  23,  10 }, {   0,  10 }, {  21,   8 }, {  11,   4 },
    {  19,   5 }, {   7,   6 }, {   4,   6 }, {  16,   3 }, {  10,   4 },
    {  18,   4 }, {  15,   3 }, {  13,   3 }, {  14,   3 },
    /* rsd_apprx - 6 entries */
    {   1,   1 }, {   2,   2 }, {   3,   3 }, {   4,   4 }, {   5,   5 },
    {   0,   5 },
    /* rsd_amp - 33 entries */
    {   2,   3 }, {   1,   3 }, {   5,   3 }, {  14,   8 }, {  20,   9 },
    {  26,  10 }, {  25,  12 }, {  32,  12 }, {  19,  11 }, {  16,   8 },
    {  24,   9 }, {  17,   9 }, {  12,   7 }, {  13,   7 }, {   9,   5 },
    {   7,   4 }, {   3,   2 }, {   4,   3 }, {   8,   6 }, {  11,   6 },
    {  18,   8 }, {  15,   8 }, {  30,  11 }, {  36,  13 }, {  34,  13 },
    {  29,  13 }, {   0,  13 }, {  21,  10 }, {  28,  10 }, {  23,  10 },
    {  22,   8 }, {  10,   6 }, {   6,   4 },
    /* avg_g3 - 18 entries */
    {  14,   4 }, {  11,   6 }, {  19,   7 }, {   9,   7 }, {  13,   5 },
    {  10,   6 }, {  20,   8 }, {   8,   8 }, {   6,  10 }, {  23,  11 },
    {   0,  11 }, {  21,   9 }, {   7,   8 }, {  12,   5 }, {  18,   4 },
    {  16,   2 }, {  15,   2 }, {  17,   2 },
    /* st_grid - 22 entries */
    {   4,   4 }, {   3,   4 }, {   8,   4 }, {  14,   8 }, {   7,   9 },
    {   9,  10 }, {  22,  10 }, {  12,   7 }, {  16,   9 }, {  11,  10 },
    {  13,  11 }, {  17,  13 }, {  15,  13 }, {  24,  13 }, {   0,  13 },
    {  18,   9 }, {  20,  10 }, {   2,  10 }, {   5,   7 }, {  10,   5 },
    {   1,   2 }, {   6,   1 },
    /* grid_2 - 20 entries */
    {   3,   2 }, {   2,   2 }, {   4,   3 }, {   5,   4 }, {   6,   5 },
    {  11,  11 }, {  13,  12 }, {  17,  12 }, {  19,  14 }, {  14,  14 },
    {  18,  13 }, {  15,  13 }, {  16,  14 }, {   0,  14 }, {  12,  11 },
    {  10,   9 }, {   9,   8 }, {   8,   7 }, {   7,   6 }, {   1,   2 },
    /* grid_3 - 13 entries */
    {  18,   3 }, {  15,   4 }, {  19,   5 }, {  14,   6 }, {  13,   8 },
    {  12,  10 }, {  11,  12 }, {   0,  12 }, {  22,  11 }, {  21,   9 },
    {  20,   7 }, {  16,   2 }, {  17,   1 },
    /* rsd - 9 entries */
    {   1,   3 }, {   5,   4 }, {   6,   5 }, {   7,   6 }, {   4,   6 },
    {   4,   3 }, {   0,   3 }, {   2,   2 }, {   3,   2 },
};

VLC     ff_dca_vlc_bit_allocation[5];
VLC     ff_dca_vlc_transition_mode[4];
VLC     ff_dca_vlc_scale_factor[5];
VLC     ff_dca_vlc_quant_index[DCA_CODE_BOOKS][7];

VLC     ff_dca_vlc_tnl_grp[5];
VLC     ff_dca_vlc_tnl_scf;
VLC     ff_dca_vlc_damp;
VLC     ff_dca_vlc_dph;
VLC     ff_dca_vlc_fst_rsd_amp;
VLC     ff_dca_vlc_rsd_apprx;
VLC     ff_dca_vlc_rsd_amp;
VLC     ff_dca_vlc_avg_g3;
VLC     ff_dca_vlc_st_grid;
VLC     ff_dca_vlc_grid_2;
VLC     ff_dca_vlc_grid_3;
VLC     ff_dca_vlc_rsd;

av_cold void ff_dca_init_vlcs(void)
{
    static VLCElem dca_table[30218];
    const uint8_t (*src_table)[2] = ff_dca_vlc_src_tables;
    unsigned offset = 0;

#define DCA_INIT_VLC(vlc, nb_bits, nb_codes, entry_offset)                  \
    do {                                                                    \
        vlc.table           = &dca_table[offset];                           \
        vlc.table_allocated = FF_ARRAY_ELEMS(dca_table) - offset;           \
        ff_init_vlc_from_lengths(&vlc, nb_bits, nb_codes, &src_table[0][1], 2, \
                                 &src_table[0][0], 2, 1, entry_offset,      \
                                 INIT_VLC_STATIC_OVERLONG, NULL);           \
        offset += vlc.table_size;                                           \
        src_table += nb_codes;                                              \
    } while (0)

    for (unsigned i = 0; i < DCA_CODE_BOOKS; i++) {
        for (unsigned j = 0; j < ff_dca_quant_index_group_size[i]; j++)
            DCA_INIT_VLC(ff_dca_vlc_quant_index[i][j], bitalloc_maxbits[i][j],
                         ff_dca_bitalloc_sizes[i], ff_dca_bitalloc_offsets[i]);
    }

    for (unsigned i = 0; i < FF_ARRAY_ELEMS(ff_dca_vlc_bit_allocation); i++)
        DCA_INIT_VLC(ff_dca_vlc_bit_allocation[i], bitalloc_12_vlc_bits[i], 12, 1);

    for (unsigned i = 0; i < FF_ARRAY_ELEMS(ff_dca_vlc_scale_factor); i++)
        DCA_INIT_VLC(ff_dca_vlc_scale_factor[i], DCA_SCALES_VLC_BITS, 129, -64);

    for (unsigned i = 0; i < FF_ARRAY_ELEMS(ff_dca_vlc_transition_mode); i++)
        DCA_INIT_VLC(ff_dca_vlc_transition_mode[i], DCA_TMODE_VLC_BITS, 4, 0);

#define LBR_INIT_VLC(vlc, nb_bits, nb_codes, entry_offset)              \
    do {                                                                \
        vlc.table           = &dca_table[offset];                       \
        vlc.table_allocated = FF_ARRAY_ELEMS(dca_table) - offset;       \
        ff_init_vlc_from_lengths(&vlc, nb_bits, nb_codes, &src_table[0][1], 2, \
                                 &src_table[0][0], 2, 1, entry_offset,  \
                                 INIT_VLC_STATIC_OVERLONG | INIT_VLC_LE,\
                                 NULL);                                 \
        offset += vlc.table_size;                                       \
        src_table += nb_codes;                                          \
    } while (0)

    for (unsigned i = 0; i < FF_ARRAY_ELEMS(ff_dca_vlc_tnl_grp); i++)
        LBR_INIT_VLC(ff_dca_vlc_tnl_grp[i], DCA_TNL_GRP_VLC_BITS, tnl_grp_sizes[i], -1);
    LBR_INIT_VLC(ff_dca_vlc_tnl_scf,     DCA_TNL_SCF_VLC_BITS,   20, -1);
    LBR_INIT_VLC(ff_dca_vlc_damp,        DCA_DAMP_VLC_BITS,       7, -1);
    LBR_INIT_VLC(ff_dca_vlc_dph,         DCA_DPH_VLC_BITS,        9, -1);
    LBR_INIT_VLC(ff_dca_vlc_fst_rsd_amp, DCA_FST_RSD_VLC_BITS,   24, -1);
    LBR_INIT_VLC(ff_dca_vlc_rsd_apprx,   DCA_RSD_APPRX_VLC_BITS,  6, -1);
    LBR_INIT_VLC(ff_dca_vlc_rsd_amp,     DCA_RSD_AMP_VLC_BITS,   33, -1);
    LBR_INIT_VLC(ff_dca_vlc_avg_g3,      DCA_AVG_G3_VLC_BITS,    18, -1);
    LBR_INIT_VLC(ff_dca_vlc_st_grid,     DCA_ST_GRID_VLC_BITS,   22, -1);
    LBR_INIT_VLC(ff_dca_vlc_grid_2,      DCA_GRID_VLC_BITS,      20, -1);
    LBR_INIT_VLC(ff_dca_vlc_grid_3,      DCA_GRID_VLC_BITS,      13, -1);
    LBR_INIT_VLC(ff_dca_vlc_rsd,         DCA_RSD_VLC_BITS,        9,  0);
}
